/* - MCMotorEncoderPositionChangeListener -
 * Display the data from a motor encoder position change event
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.EncoderPositionChangeListener;
import com.phidgets.event.EncoderPositionChangeEvent;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class MCEncoderPositionChangeListener implements EncoderPositionChangeListener {

    private JComboBox motorCmb;
    private JTextField encoderArray[];

    public MCEncoderPositionChangeListener(JTextField encoderArray[], JComboBox motorCmb) {
        this.motorCmb = motorCmb;
        this.encoderArray = encoderArray;
    }

    public void encoderPositionChanged(EncoderPositionChangeEvent EncoderPositionEvent) {
        encoderArray[EncoderPositionEvent.getIndex()].setText(Integer.toString(EncoderPositionEvent.getValue()));
    }
}
